/*******************************************************************************
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2005 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by FREESCALE in this matter are performed AS IS and without 
any warranty. CUSTOMER retains the final decision relative to the total design 
and functionality of the end product. FREESCALE neither guarantees nor will be 
held liable by CUSTOMER for the success of this project.
FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, 
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR 
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE OR ADVISE SUPPLIED TO THE PROJECT
BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT
SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.

CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial, 
contractual, or tortuous, rising directly or indirectly as a result of an advise
or assistance supplied CUSTOMER in connection with product, services or goods 
supplied under this Agreement.
********************************************************************************
* File      main.c
* Owner     r62780
* Version   1.0
* Date      Oct-4-2010
* Classification   General Business Information
* Brief     COP (Watch Dog) usage example
********************************************************************************
* Detailed Description:
*
* - The SW demonstrates COP watchdog and MCU start after COP reset
*   It uses COP interrupt vector which is called after COP reset and inside the
*   COP interrupt it calls first program function _Startup() => Starts program 
*   from * the beginning
*
*
*  Recomendations: 
*   - Use as low capacitor connected to the reset pin as possible
*   - To see corect behavior disconnect BDM interface from board
*
*
* - tested on: TWR-S12G128
*   - OSCCLK = 8MHz oscillator, BUSCLK = 25MHz set by means of PLL in PEE mode
*   - Reference to documentation: MC9S12GRMV1 Rev.1.01
*
* - Important formulas for PLL setup:
*
*   if ext. oscillator is enabled (OSCE = 1);   fref = fosc / (REFDIV + 1)
*   if ext. oscillator is disabled (OSCE = 0);  fref = fIRC1M
*                                               fvco = 2 * fref * (SYNDIV + 1)
*   if PLL is locked (LOCK = 1);                fpll = fvco / (POSTDIV + 1)
*   if PLL is not locked (LOCK = 0);            fpll = fvco / 4
*   if PLL is selected (PLLSEL = 1);            fbus = fpll / 2
********************************************************************************
Revision History:
Version  Date         Author  Description of Changes
1.0      Aug-29-2011  R62780  Initial version
*******************************************************************************/
#include <hidef.h>           // common defines and macros 
#include "derivative.h"      //derivative-specific definitions 

//******************************************************************************
// Local types definitions
//******************************************************************************
#define     UBYTE       unsigned char
#define     SBYTE                char
#define     UWORD       unsigned  int

//******************************************************************************

#pragma DATA_SEG DEFAULT

//******************************************************************************
// Global variables
//******************************************************************************
static volatile UWORD  j,k,m;               // software delay constant      
//******************************************************************************
#pragma CODE_SEG DEFAULT
//******************************************************************************
// Local functions definitions
//******************************************************************************
void  main(void);
void _Startup(void);
void SetPEEmodeBUSCLK(UBYTE _synr, UBYTE _refdv, UBYTE _postdiv);

#pragma CODE_SEG NON_BANKED
interrupt 2  void COP_Isr(void);
interrupt 28 void PLL_LockIsr(void);
#pragma CODE_SEG DEFAULT

//******************************************************************************
#pragma CODE_SEG NON_BANKED
interrupt 28 void PLL_LockIsr(void)
{
  if(CPMUFLG_LOCK == 0)  {    /*do something here*/  }
  else                   {    /*do something here*/  }
}
#pragma CODE_SEG DEFAULT
//******************************************************************************
void SetPEEmodeBUSCLK(UBYTE _synr, UBYTE _refdv, UBYTE _postdiv)
{
 
 //--------------------------------------
 CPMUCOP = 0x43;                          // period 2^20*oscclk=0.131072 @ 8MHz OSCCLK, freeze COP in active BDM
 asm nop;
 //--------------------------------------

 CPMUSYNR    = _synr;
 CPMUREFDIV  = _refdv;
 CPMUPOSTDIV = _postdiv;   
  
 CPMUOSC_OSCE = 1; //enable external oscillator OSCE
    
 while(!CPMUFLG_UPOSC)
  {
    CPMUARMCOP=0x55;CPMUARMCOP=0xAA;
  };    
 while(!CPMUFLG_LOCK)
  {
    CPMUARMCOP=0x55;CPMUARMCOP=0xAA;
  };    
 
  //--- select clocks --------------------
 
 CPMUCLKS = 0B10000000;                   // bus=fPLL/2; COP is clocked from OSCCLK
 if(CPMUCLKS != 0B10000011)               // After writing CPMUCLKS register, it is strongly recommended to read  
  {                                       // back CPMUCLKS register to make sure that write of PLLSEL,
     asm nop;                             // RTIOSCSEL, COPOSCSEL0 and COPOSCSEL1 was successful.
  }
 asm nop;
 //--------------------------------------
 CPMUCOP = 0x44;                          // period 2^20*oscclk=0.131072 @ 8MHz OSCCLK, freeze COP in active BDM
 //--------------------------------------
}
//******************************************************************************
#pragma CODE_SEG DEFAULT

void main(void)
{ 
 ECLKCTL_NECLK = 0;                       // enable ECLK output (bus clock is visible on pin PB0)

 //--- Visualize start of main routine --
 //DDRB  = 0x06;                            // PTB2,1 as output
 //PORTB_PB1 = 0;                           // switch off the port
 //PORTB_PB2 = 0;                           // switch off the port
 //--- PLL Initialization ---------------
 //SetPEEmodeBUSCLK(0x03, 0x40, 0x00);      // 16MHz BUSCLK from 4 MHZ oscclk, PEE mode
 SetPEEmodeBUSCLK(0x01, 0x80, 0x00);    // 16MHz BUSCLK from 8 MHZ oscclk, PEE mode

 //--------------------------------------
 while(1) 
  { PORTB_PB1 = ~PORTB_PB1;
    //CPMUARMCOP=0x55;CPMUARMCOP=0xAA;
  }

 //--------------------------------------
}
//******************************************************************************
#pragma CODE_SEG NON_BANKED

interrupt 2 void COP_Isr(void)
{
  DDRB  = 0x06;                           // PTB2,1 as output
  PORTB_PB1 = 0;                          // switch off the port
  PORTB_PB2 = 0;                          // switch off the port

  asm JMP _Startup;                       // this code jumps to the _Startup
}
#pragma CODE_SEG DEFAULT
//******************************************************************************
/*
 We are testing the Software in Freescale evaluation board, still we didnt get the
 correct COP time out.

 Following cfg done for S12G128 micro - 8MHz OSCLK and 16MHz Bus clock.

 During startup sequence, setting CPMUCOP = (B_RSBCK|B_CR2)
 Again during write once call, setting CPMUCOP = (B_RSBCK|B_CR2)

 PLL wait loop is coded as below



    R_CPMUOSC |= (UINT8)B_OSCE;                             \

    do                                                      \
      {
    
       if ((R_CPMUFLG & (UINT8)B_LOCK) == (UINT8)B_LOCK)    \
        {                                                   \
          // select the PLL as system clock                 \
          R_CPMUCLKS |= (UINT8)(B_PLLSEL|B_COPOSCSEL0);
        }                                                   \
    
      }
    while ( (R_CPMUFLG & (UINT8)B_UPOSC)!=(UINT8)B_UPOSC);  \
    
    R_CPMUFLG = 0xff;                                       \
    R_CPMUCLKS |= (B_COPOSCSEL0|B_RTIOSCSEL);

 
 
 When the  CPMUCOP register is loaded twice, B_COPOSCSEL0 bit is not set in the R_CPMUCLKS.
 Could you please provide your comments for this? Will there any impact if CPMUCOP is set twice?
 When CPMUCOP register is loaded once, B_COPOSCSEL0 bit is set in the R_CPMUCLKS.
*/
















